<?php

/* -----------------------------------
This file is part of MxSolutions 5.7 and above
Copyright:      Logical Developments 2006 substantially modified by Lokanet Pty Limited 2014-2015.
Project:        Web based modular system
Filename:       rpc.php
Author:         Paul Mulroney
version:        0.05
Description: 	XML Request broker for the modular system
History:
0.00    19-05-06 PWM   Created.
0.01	31-10-06 PWM   (ld0002648) Added option to return headers if passed in from Omnis
0.02	08-02-07 PWM   (ld0002818) Trap special chars in conversion string.
0.03	22-03-07 PWM   Extracted Omnis calls into separate file.
0.04	10-04-07 PWM   (ld0002991) Fixed problem with multiple header output.
0.05	29-02-12 PWM   (mx0001083) Suppress undefined index errors.
----------------------------------- */

include_once "config.php"; //load our config data
include_once "omnis.php";

session_start(); //start the session

//if we just came from the login page
if (!isset($_POST['Username'])) //If not isset -> set with dumy value 
{
	$_POST['Username'] = ""; 
}
if($_POST['Username'] != "") {
	//print_r($_POST);
	$_SESSION['Username'] = $_POST['Username'];
	$_SESSION['Password'] = $_POST['Password'];
}
//if the user is logging out erase the session variables
if (!isset($_GET['op'])) //If not isset -> set with dumy value 
{
	$_GET['op'] = ""; 
}
if($_GET['op'] == "Logout") {
	$_SESSION['Username'] = "";
	$_SESSION['Password'] = "";
}
$logindata = OmnisRequest("OmnisServer=$omnisserver:$omnisport&OmnisClass=rtLDBroker&OmnisLibrary=Bookings&CMD=GetLogin&Params=".$_SESSION['Username']."|".$_SESSION['Password']);
if(($logindata == "_noone")|($logindata == "404")) { //omnis returns "_noone" if the login is incorrect
	$query = $_SERVER['QUERY_STRING'];
	if(strpos($query, "Login") === false) { // if we're not at the login page go there
		header( "Location: index.php?op=Login" );
		die; // additional output can cause problems so let's just stop output here
	}
}

if($_GET['op'] == "") { //if nothing show the welcome page
	$op = "INIT";
} else { //otherwise ask omnis to give us the page
	$op = $_GET['op'];
}
$outputtxt = OmnisRequest("OmnisServer=$omnisserver:$omnisport&OmnisClass=rtLDBroker&OmnisLibrary=Bookings&CMD=".$op."&Username=".$_SESSION['Username'].arr2and($_GET).arr2and($_POST));
if(substr($outputtxt,0,6) == "redir:") {
	header( "Location: ".substr($outputtxt,6) );
	die(); // additional output can cause problems so let's just stop output here
}

$pos=strpos(strtolower($outputtxt),"content-type"); // do we have headers being returned?
if(($outputtxt == "404")|($outputtxt == "")) { 		//Omnis returns 404 if the command isn't found
	echo "<p>Error: Command not implemented</p><p>This command is either not yet operational or you clicked on a bad link. If you feel that it was a bad link please let us know by emailing us at <a href=\"mailto:support@mxsolutions.com.au\">support@mxsolutions.com.au</a>.</p> <p><a href=\"index.php\">Return to the home page</a> to continue.</p>";
} elseif(($outputtxt == "504 Gateway Time-out - could not connect to OMNIS server or load sharing process\n(Reported by OMNIS CGI program)")|($outputtxt == "503 Unable to locate specified Library or Class")) {
	echo "<p>Error: The database is currently offline, please try to connect later</p>";
} elseif($pos === false) { 							//yay we got a page!
	echo $outputtxt;
} else { 											// Got headers, need to extract the headers and the body
	$pos=strpos($outputtxt,sprintf("%c%c%c%c",13,10,13,10));	// The location of the break between the header and not
	$headers=explode(sprintf("%c%c",13,10),substr($outputtxt,0,$pos)); // Convert into an array of headers.
	$body=substr($outputtxt,$pos+4,strlen($outputtxt)); 		// The second part is the body

	foreach($headers as $thisheader) {
		header($thisheader);	// output each header in turn
	}
	echo $body;			// output the body
}
?>