<?php
/* -----------------------------------
This file is part of MxSolutions 5.7 and above
Copyright:      Logical Developments 2007 substantially modified by Lokanet Pty Limited 2014-2015.
Project:        Web based modular system
Filename:       Omnis.php
Author:         Paul Mulroney
version:        0.00
Description: 	Omnis Web Server interface to modular system
History:
0.00    22-03-07 PWM   Created.
----------------------------------- */

include_once "config.php"; //load our config data

// Return an encoded URL from an array of values.
function arr2and($arr) {
	$retval = "";
	foreach($arr as $key => $value) {
		$retval = $retval."&$key=".urlencode("$value"); // Need to trap special chars
	}
	if(substr($retval,strlen($retval)-1) == "&") {
		$retval = substr($retval,0,strlen($retval)-1);
	}
	return $retval;
}

// Use CURL to retrieve page
function PostCurlPage ($pageSpec, $PostString) {
   $ch = curl_init($pageSpec);
   curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
   curl_setopt($ch, CURLOPT_POST, 1);
   curl_setopt($ch, CURLOPT_POSTFIELDS, $PostString."&IPAddress=".$_SERVER['REMOTE_ADDR']);
   $tmp = curl_exec ($ch);
   curl_close ($ch);
   return $tmp;
}

// Omnis request using CURL

function OmnisRequest($PostString) {
	global $omniscgipath; // defined in the config.php
	
	// Make a request of Omnis, return result
	return PostCurlPage($omniscgipath,$PostString);
}

// Note there's a problem with this right now - something to do with the headers makes it fail with rpc.php.

/* ----
// Omnis request using just PHP - no CGI required.
function OmnisRequest($PostString) {
	global $omnisserver;
	global $omnisport;
	
	//	Append IPAddress to the request
	$PostString.="&IPAddress=".$_SERVER['REMOTE_ADDR'];
	
	// Make the request
	$result="";
	$socket = fsockopen($omnisserver,$omnisport,$errno,$errtext,$timeout);	// Make the connection
	if (!$socket) { 
		// Failed to open connection
		$result="Error: ".$errno." ".$errtext;								
	} else {
		// Calculate Omnis RFC header
		$omnis_header = 'OMNIS_ORFC' . sprintf('%c%c%c%c%c%c%c%c%c', 0, 1, 0, 7, 1, 0, 0, 127, 0);
        $block_length   = strlen($omnis_header.$PostString) + 4;
        $asc4           = $block_length % 256;
        $block_length   = ($block_length - $asc4) / 256;
        $asc3           = $block_length % 256;
        $block_length   = ($block_length - $asc3) / 256;
        $asc2           = $block_length % 256;
        $asc1           = ($block_length - $asc2) / 256;

		// Send the request
		fwrite($socket,sprintf('%c%c%c%c', $asc1, $asc2, $asc3, $asc4).$omnis_header); // Write header length + header
  		fwrite($socket,$PostString); // Write the post string
		
		// Get the result
		while (!feof($socket)) {
			// Read headers.  
			do {
				$header=trim(fgets($socket, 1024)); 	// Read header, strip cr/lf char.
				$info = stream_get_meta_data($socket);	// Was there any problems?
				if ($info['timed_out']) {				// Yes, socket timed out, close connection.
					fclose($socket);
				}
				if(strpos($header, 'Content-length:') === 0) {
					list(, $content_length) = explode(':', $header, 2);
					$content_length = (int) trim($content_length)+10;	// add 10 to be sure to be sure.
				}
			} while(strlen($header)>0);					// Until we reach the cr/lf/cr/lf			
			
			// Read the contents
			while(!feof($socket)) {
				if ($content_length==0) { 				// Failsafe.  For some reason getting no length there for a bit
					$content_length=100;
				}
				$result .= trim(fread($socket, $content_length));
				$info = stream_get_meta_data($socket);
				if ($info['timed_out']) {
					fclose($socket);
				}
			}
		}

		fclose($socket);
	}
	// Strip OMNIS_ORFC header, if it's there.
	$pos=strpos($result,'OMNIS_ORFC');
	if ($pos!=0){
		$result=substr($result,$pos+14); // After the OMNIS_ORFC+4 bytes, rest of the string.
	}
	return $result;
}		
--- */

?>