/* -----------------------------------
This file is part of MxSolutions 5.7 and above
Copyright:      Logical Developments 2005 modified by Lokanet Pty Limited 2014-2015.
Project:        Web based modular system
Filename:       tabs.js
Author:         Paul W Mulroney
version:        0.08
Description: 	Used to select the appropriate "tab" on the window.
History:
0.00    25-07-06 PWM   Created.
0.01	28-03-07 PWM   (ld0002910) Resize the window to match the extra information.
0.02	11-04-07 PWM   (ld0002989) Made slightly longer for Firefox/windows.
0.03	12-06-07 PWM   (ld0003079) Make the Patient the default tab.
0.04	03-11-08 PWM   (mx0000532) Make the window bigger if "Add To Theatre List"
0.05	03-06-10 PWM   (mx0000798) bkNotes2->bkSurname
0.06	29-06-10 PWM   (mx0000825) Changed how the windows are resized, to be more flexible.
0.07	16-09-10 PWM   Make the first field in the tab active.
0.08	13-12-10 PWM   (mx0000943) Adjust window size to allow for address bar etc.
0.09	07-06-18 RP		Height adjustment for Windows because it was truncating at the bottom.
----------------------------------- */
var lastSelection="Patient";  // First option is the default last selection.

function SetTab(psOption) {
	// Make the appropriate DIV visible on the screen
	// IN: the name of the DIV to hide/show.  Note that the tab must be called tab<DIV name>.
	
	// Define the div names
	var panes = new Array("","NewPatient","Patient");  		// An array of texts that represent the Div for this tab.  
	var fields = new Array("","bkSurname","PatientName");	// An array of field names that represents the first field on each tab.
	
	for (i=1; i<panes.length; i++) {
		thisDiv=panes[i];
		thisTab="tab"+thisDiv;  							// Tab name is tabNewPatient etc.
		if (thisDiv != "") {
			oDiv=document.getElementById(thisDiv).style;  	// locate the div to display
			oTab=document.getElementById(thisTab);			// and the corresponding tab
			if (thisDiv==psOption) { 						// Want to show this one
				oDiv.display="block";
				oTab.className="tabselected";
				lastSelection=thisDiv;		
				document.getElementById(fields[i]).focus();	// Make the first field in the tab active.
			} else { 										// want to hide this one
				oDiv.display="none";
				oTab.className="";
			} // found a match
		} // thisDiv is not blank
	} // for loop
	
	// dynamically resize window to match
	var vnNewHeight=0;							
	var voBottom = document.getElementById("bottom");		// This is the Save/Cancel button at the bottom of the page.
	var vnOffset = 60;	                                    // Default offset amount.  Assuming no address bar or status bar.

	vnNewHeight = voBottom.offsetHeight+voBottom.offsetTop+vnOffset;
	//Try to make the form taller on Windows	
	if (navigator.platform.substr(0,3) == "Win")  {
		vnNewHeight=vnNewHeight+25;
	}
	
	var vnWidth=window.outerWidth;							// Width is unchanged
	self.resizeTo(vnWidth,vnNewHeight);						// New height
	//alert(navigator.platform);
	
} // function SetTab()

// -----------------------------------