/* -----------------------------------
This file is part of MxSolutions 5.7 and above
Copyright:      Logical Developments 2006 modified by Lokanet Pty Limited 2014-2015.
Project:        Mx Web Calendar System
Filename:       postcode.js
Author:         Paul W Mulroney
version:        0.01
Description: 	Lookup postcode from Mx system. 
History:
0.00    15-05-07 PWM   Created.
0.01	01-08-07 PWM   Added State to the response.
------------------------------------ */

// Note that this opens on the create patient window, so we have to define our create method here.

// The request object used for transmission 
function createRequestObject() { 
     var ro; 
     var browser = navigator.appName; 
     if(browser == "Microsoft Internet Explorer"){ 
         ro = new ActiveXObject("Microsoft.XMLHTTP"); 
     }else{ 
         ro = new XMLHttpRequest(); 
     } 
     return ro; 
} 
  
// Our normal request object.  
var postcode = createRequestObject(); 
var ibHttpBusy = false;	// Global associated with http
 
function sendRequest(action) { 
     if (ibHttpBusy==false) {	// If we're busy, we can't have two reqeusts at once.
		 postcode.open('get', 'rpc.php?op='+action); 
		 ibHttpBusy = true;	// We're busy now
		 postcode.onreadystatechange = handleResponse; 
		 postcode.send(null); 
	}
} 
  
function handleResponse() { 
    // Write response to the Suburb/state/postcode fields.  Response is expected in the format <suburb>|<state>|<postcode> 
    if(postcode.readyState == 4){ 	//4= response is completed. 
         ibHttpBusy = false;  	// no longer busy
		 hideWorkingMessage();	// We're done working
         var response = postcode.responseText; 
         var update = new Array(); 

         if(response.indexOf('|' != -1)) { 
             update = response.split('|'); 
             try {	// Try to update it.  If it didn't work, we don't really care.
             	document.getElementById("P_MSTATE").value=update[1];
             	document.getElementById("P_MPOSTC").value=update[2];           
	         } catch(e) {
			     // Do nothing.  
             }
         } 
     }
} 

// -- the find routine called by the web page
function findPostcode(psSuburbField) {
	var vsSuburb=psSuburbField.value;
	// Escape quote fields.  Needed to make Get request work properly
	vsSuburb=escape(vsSuburb); 
	var action='Postcode&Suburb='+vsSuburb;
	showWorkingMessage();
	sendRequest(action);
}

// -- Working message handing routines
function showWorkingMessage() {
	var wm=document.getElementById("WorkingMsg");
	if (wm!=null) {
     	wm.style.display = 'block'; // show the working message.	
	}
}

function hideWorkingMessage() {
	var wm=document.getElementById("WorkingMsg");
	if (wm!=null) {
		wm.style.display = 'none';	// hide the working message.
	}         
}

// -----------------------------------