/* -----------------------------------
This file is part of MxSolutions 5.7 and above
Copyright:      Logical Developments 2007 modified by Lokanet Pty Limited 2014-2015.
Project:        Mx Web Calendar System
Filename:       findrefdr.js
Author:         Paul W Mulroney
version:        0.00
Description: 	Find referring doctor routines. 
History:
0.00    01-08-07 PWM   Created.
------------------------------------ */

// Note that this opens on a separate window, so we have to define our create method here.

// The request object used for transmission 
function createRefDrRequestObject() { 
     var ro; 
     var browser = navigator.appName; 
     if(browser == "Microsoft Internet Explorer"){ 
         ro = new ActiveXObject("Microsoft.XMLHTTP"); 
     }else{ 
         ro = new XMLHttpRequest(); 
     } 
     return ro; 
} 
  
// Our normal request object.  
var httpRefDr = createRefDrRequestObject(); 
var ibHttpRefDrBusy = false;	// Global associated with http
 
function sendRefDrRequest(action) { 
     if (ibHttpRefDrBusy==false) {	// If we're busy, we can't have two reqeusts at once.
		 httpRefDr.open('get', 'rpc.php?op='+action); 
		 ibHttpRefDrBusy = true;	// We're busy now
		 httpRefDr.onreadystatechange = handleRefDrResponse; 
		 httpRefDr.send(null); 
	}
} 
  
function handleRefDrResponse() { 
    // Write response to the given DIV name.  Response is expected in the format <div name>|<div contents> 
    if(httpRefDr.readyState == 4){ 	//4= response is completed. 
         ibHttpRefDrBusy = false;  	// no longer busy
		 hideWorkingMessage();	// We're done working
         var response = httpRefDr.responseText; 
         var update = new Array(); 

         if(response.indexOf('|' != -1)) { 
             update = response.split('|'); 
             try {	// Try to update it.  If it didn't work, we don't really care.
	             document.getElementById(update[0]).innerHTML = update[1]; 
	         } catch(e) {
			     // Do nothing.  
             }
         } 
     }
} 

// -- the find routine called by the web page
function findRefDr(psName) {
	// Escape quote fields.  Needed to make Get request work properly
	psName=escape(psName); 
	var action='mxFindRefDr&Name='+psName;
	showWorkingMessage();
	sendRefDrRequest(action);
}

function loadRefDrNow() {
	// Run from a timer, use the current value to reload
	var patID=document.getElementById("P_MRDNAM");
	var vsNumber=patID.value;	
	findRefDr(vsNumber);
}

function loadRefDr(psName) {
	// Populate the patient number from the calling window.
	// Then, load the patient details using a standard find.
	// Use a timer to bypass a problem with firefox.
	var patID=document.getElementById("P_MRDNAM");
	patID.value=psNumber;
	var lp=setTimeout("loadRefDrNow()",1000);	// wait a second, then run it.
}

// -- Working message handing routines
function showWorkingMessage() {
	var wm=document.getElementById("WorkingMsg");
	if (wm!=null) {
     	wm.style.display = 'block'; // show the working message.	
	}
}

function hideWorkingMessage() {
	var wm=document.getElementById("WorkingMsg");
	if (wm!=null) {
		wm.style.display = 'none';	// hide the working message.
	}         
}

// -----------------------------------