/* -----------------------------------
This file is part of MxSolutions 5.7 and above
Copyright:      Logical Developments 2006 modified by Lokanet Pty Limited 2014-2015.
Project:        Mx Web Calendar System
Filename:       findpatient.js
Author:         Paul W Mulroney
version:        0.08
Description: 	Find patient routines. 
History:
0.00    12-07-06 PWM   Created.
0.01	25-10-06 PWM   (ld0002646) Added loadPatient() routine to allow load from New Patient window.
0.02	25-10-06 PWM   (ld0002594) Enabled find on phone number.
0.03	13-11-06 PWM   (ld0002729) Added option to search on DOB.
0.04	24-03-07 PWM   (ld0002962) Added Date to find patient.  Required for referral date.
0.05	02-04-07 PWM   (ld0002811) Do not abort connection, causes problems at the other end.
0.06	08-04-07 PWM   (ld0002989) Escape quote the parameters in the Get command.
0.07	08-04-07 PWM   (ld0002990) Added practitioner to the find calculation.
0.08	03-06-10 PWM   (mx0000429) Added extra find patient routines for autofind on patient name and number.
------------------------------------ */

// Note that this opens on a separate window, so we have to define our create method here.

// The request object used for transmission 
function createRequestObject() { 
     var ro; 
     var browser = navigator.appName; 
     if(browser == "Microsoft Internet Explorer"){ 
         ro = new ActiveXObject("Microsoft.XMLHTTP"); 
     }else{ 
         ro = new XMLHttpRequest(); 
     } 
     return ro; 
} 
  
// Our normal request object.  
var http = createRequestObject(); 
var ibHttpBusy = false;	// Global associated with http
 
function sendRequest(action) { 
     if (ibHttpBusy==false) {	// If we're busy, we can't have two reqeusts at once.
		 http.open('get', 'rpc.php?op='+action); 
		 ibHttpBusy = true;	// We're busy now
		 http.onreadystatechange = handleResponse; 
		 http.send(null); 
	}
} 
  
function handleResponse() { 
    // Write response to the given DIV name.  Response is expected in the format <div name>|<div contents> 
    if(http.readyState == 4){ 	//4= response is completed. 
         ibHttpBusy = false;  	// no longer busy
		 hideWorkingMessage();	// We're done working
         var response = http.responseText; 
         var update = new Array(); 

         if(response.indexOf('|' != -1)) { 
             update = response.split('|'); 
             try {	// Try to update it.  If it didn't work, we don't really care.
	             document.getElementById(update[0]).innerHTML = update[1]; 
	         } catch(e) {
			     // Do nothing.  
             }
         } 
     }
} 

// -- the find routine called by the web page
function findPatient(psName,psNumber,psPhone,psDOB,psDate,psPractitioner) {
	// Escape quote fields.  Needed to make Get request work properly
	psName=escape(psName); 
	psNumber=escape(psNumber);
	psPhone=escape(psPhone);
	psDOB=escape(psDOB);
	psDate=escape(psDate);
	psPractitioner=escape(psPractitioner);
	var action='mxFind&PatientName='+psName+'&PatientNumber='+psNumber+'&PatientPhone='+psPhone+'&PatientDOB='+psDOB+'&Date='+psDate+'&Practitioner='+psPractitioner;
	showWorkingMessage();
	sendRequest(action);
}

function findPatient2(psName,psNumber,psPhone,psDOB,psDate,psPractitioner) {
	// User has entered name and nothing else, auto find on name
	if ((psName != '') && (psNumber == '')) {
		findPatient(psName,psNumber,psPhone,psDOB,psDate,psPractitioner);
	}
}

function findPatient3(psName,psNumber,psPhone,psDOB,psDate,psPractitioner) {
	// User has entered number and nothing else, auto find on number
	if ((psName == '') && (psNumber != '')) {
		findPatient(psName,psNumber,psPhone,psDOB,psDate,psPractitioner);
	}
}

function loadPatientNow() {
	// Run from a timer, use the current value to reload
	var patID=document.getElementById("PatientNumber");
	var vsNumber=patID.value;	
	findPatient('',vsNumber,'');
}

function loadPatient(psNumber) {
	// Populate the patient number from the calling window.
	// Then, load the patient details using a standard find.
	// Use a timer to bypass a problem with firefox.
	var patID=document.getElementById("PatientNumber");
	patID.value=psNumber;
	var lp=setTimeout("loadPatientNow()",1000);	// wait a second, then run it.
}

// -- Working message handing routines
function showWorkingMessage() {
	var wm=document.getElementById("WorkingMsg");
	if (wm!=null) {
     	wm.style.display = 'block'; // show the working message.	
	}
}

function hideWorkingMessage() {
	var wm=document.getElementById("WorkingMsg");
	if (wm!=null) {
		wm.style.display = 'none';	// hide the working message.
	}         
}

// -----------------------------------