/* -----------------------------------
This file is part of MxSolutions 5.7 and above
Copyright:      Logical Developments 2005 modified by Lokanet Pty Limited 2014-2015.
Project:        Web based modular system
Filename:       find.js
Author:         Paul W Mulroney
version:        1.03
Description: 	Find functions on the Mx Schedule system
History:
0.00    25-07-06 PWM   Created.
1.00	27-11-06 PWM   Rewritten to use tabbed interface.
1.01	27-03-07 PWM   (ld0002951) Added FindNewPatient tab.
1.02	22-08-08 PWM   (mx0000395) Added method QueueField()
1.03	11-08-10 PWM   (mx0000798) bkNotes2->bkSurname
----------------------------------- */

var lastSelection="NextAvail";  // First option is the default last selection.

function SelectOption(psOption) {
	// Make the appropriate DIV visible on the screen
	// IN: the name of the DIV to hide/show.  Note that the tab must be called tab<DIV name>.
	
	// Define the div names
	var panes = new Array("","NextAvail","FindPatient","FindNewPatient","Type");  // An array of texts.  
	var fields = new Array("","","PatientName","bkSurname","") // corresponding field focus
	
	for (i=1; i<panes.length; i++) {
		thisDiv=panes[i];
		thisTab="tab"+thisDiv;  							// Tab name is tabNewPatient etc.
		if (thisDiv != "") {
			oDiv=document.getElementById(thisDiv).style;	// locate the div to display
			oTab=document.getElementById(thisTab);			// and the corresponding tab
			if (thisDiv==psOption) { 						// Want to show this one
				oDiv.display="block";
				oTab.className="tabselected";
				lastSelection=thisDiv;
				// Set the focus to the first field in this pane.
				QueueField(fields[i]); 
			} else {										// Want to hide this one
				oDiv.display="none";
				oTab.className="";
			} // found a match
		} // thisDiv is not blank
	} // for loop
} // function SelectOption()

function QueueField(psFieldName) {
	// Set the current field name as the one where the cursor is
	thisField=document.getElementById(psFieldName);
	thisField.focus();
	return false;
} // function QueueField()

// -----------------------------------