/* -----------------------------------
This file is part of MxSolutions 5.7 and above
Copyright:      Logical Developments 2006 modified by Lokanet Pty Limited 2014-2015.
Project:        Mx Web Calendar System
Filename:       ctxmenu.js
Author:         Paul W Mulroney
version:        0.11
Description: 	Contextual menu handling routines
History:
0.00    12-07-06 PWM   Created.
0.01	25-10-06 PWM   Fixed location of contextual menu.
0.02	12-11-06 PWM   Tweaked for Internet Explorer 7.  
0.03	11-04-07 PWM   (ld0002989) Made add/edit/delete window slightly longer
0.04	01-08-07 PWM   (ld0003142) Fix problem with contextual menu opening below bottom of page.
0.05	02-08-07 PWM   (ld0003133) Make the add/edit/delete/print windows open in the top/left corner.
0.06	21-08-07 PWM   (ld0003157) Highlight the cell where the contextual menu opens onto.
0.07	15-10-07 PWM   (ld0003230) Added cut/paste functionality.
0.08	24-02-08 PWM   (mx0000228) Added copy/paste functionality. (mx0000234) Added delete recurring.
0.09	17-02-10 PWM   (mx0000697) Added Goto Patient functionality.
0.10	24-03-10 PWM   (mx0000275) Added cut from waitlist functionality.
0.11	27-05-10 PWM   (mx0000733) Added option to highlight a particular appt cell.
0.12	29-02-12 PWM   (mx0001082) Close the menu after 10 seconds, not 5 seconds.
----------------------------------- */

// Handling options from the links inside the menu
var bkSeq=0; 		// Initialise our record reference.

// Our Contextual Menu request object.  Used to handle the Nav and Cal areas, and then update the Sched area.
// Note ajax.js must be loaded beforehand.  createRequestObject(), sendSchedRequest() defined there
var voCtx = createRequestObject(); 
 
function sendCtxRequest(action) { 
     voCtx.open('get', 'rpc.php?op='+action); 
     voCtx.onreadystatechange = handleCtxResponse; 
     voCtx.send(null); 
} 
  
function handleCtxResponse() { 
    // Write response to the given DIV name.  Response is expected in the format <div name>|<div contents> 
    if(voCtx.readyState == 4){ //4= response is completed. 
         var response = voCtx.responseText; 
		 // make the schedule update next.  Always.
		 sendSchedRequest();
     } 
} 

// --- Contextual menu option handlers: Add/Edit/Delete/Status
function ctxAdd() {
	hideCtxMenu();
	var url='rpc.php?op=bkAdd&bkSeq='+bkSeq;
	addWindow=window.open(url,"_blank","height=500,width=800,resizable=1,scrollbars=1,location=0");
	addWindow.moveTo(0,0); // open in the top/left corner.
}

function ctxEdit() {
	hideCtxMenu();
	var bkStr=""+bkSeq;
	if (bkStr.indexOf('/')>0) { // Found this is an empty slot, because bkSeq=hh:mm/resource
		alert('There is no appointment to edit in this timeslot');
	} else {
		var url='rpc.php?op=bkEdit&bkSeq='+bkSeq;
		editWindow=window.open(url,"Edit_Appointment","height=500,width=800,resizable=1,scrollbars=1,location=0");
		editWindow.moveTo(0,0); // open in the top/left corner.
	}
}

function ctxDelete() { // Delete single appointment
	hideCtxMenu();
	var bkStr=""+bkSeq;
	if (bkStr.indexOf('/')>0) { // Found this is an empty slot, because bkSeq=hh:mm/resource
		alert('There is no appointment to delete in this timeslot');
	} else {
		var url='rpc.php?op=bkDelete&bkSeq='+bkSeq;
		deleteWindow=window.open(url,"Delete_Appointment","height=500,width=800,resizable=1,scrollbars=1,location=0");
		deleteWindow.moveTo(0,0); // open in the top/left corner.
	}
}

function ctxDeleteRec() { // Delete recurring appointment.
	hideCtxMenu();
	var bkStr=""+bkSeq;
	if (bkStr.indexOf('/')>0) { // Found this is an empty slot, because bkSeq=hh:mm/resource
		alert('There is no recurring appointment to delete in this timeslot');
	} else {
		var url='rpc.php?op=bkDeleteRec&bkSeq='+bkSeq;
		deleteWindow=window.open(url,"Delete_Recurring_Appointment","height=500,width=800,resizable=1,scrollbars=1,location=0");
		deleteWindow.moveTo(0,0); // open in the top/left corner.
	}
}

function ctxStatus(psBcCode){
	hideCtxMenu();
	var bkStr=""+bkSeq;
	if (bkStr.indexOf('/')>0) { // Found this is an empty slot, because bkSeq=hh:mm/resource
		alert('There is no appointment to update in this timeslot');
	} else {
		var action='bkStatus&bkSeq='+bkSeq+'&bcCode='+psBcCode;
		sendCtxRequest(action); // our ajax handler, send a request to the window and redraw schedule when done.
	}
}

// --- Cut/Paste appointments
function ctxCut() {
	hideCtxMenu();
	var bkStr=""+bkSeq;
	if (bkStr.indexOf('/')>0) { // Found this is an empty slot, because bkSeq=hh:mm/resource
		alert('There is no appointment to update in this timeslot');
	} else {
		var url='bkCut&bkSeq='+bkSeq;
		sendCtxRequest(url);
	}
}

function ctxCutWaitlist() {
	hideCtxMenu();
	var bkStr=""+bkSeq;
	if (bkStr.indexOf('/')>0) { // Found this is an empty slot, because bkSeq=hh:mm/resource
		alert('There is no appointment to update in this timeslot');
	} else {
		var url='bkCut&bkSeq='+bkSeq+'&waitlist=1';
		sendCtxRequest(url);
	}
}

function ctxCopy() {
	hideCtxMenu();
	var bkStr=""+bkSeq;
	if (bkStr.indexOf('/')>0) { // Found this is an empty slot, because bkSeq=hh:mm/resource
		alert('There is no appointment to update in this timeslot');
	} else {
		var url='bkCopy&bkSeq='+bkSeq;
		sendCtxRequest(url);
	}
}

function ctxPaste() {
	hideCtxMenu();
	var bkStr=""+bkSeq;
	var url='bkPaste&bkSeq='+bkSeq;
	sendCtxRequest(url);
}

// --- Send letter
function ctxSendLetter() {
	hideCtxMenu();
	var bkStr=""+bkSeq;
	if (bkStr.indexOf('/')>0) { // Found this is an empty slot, because bkSeq=hh:mm/resource
		alert('There is no appointment to send letter for in this timeslot');
	} else {
		var url='rpc.php?op=PrintLetter&bkSeq='+bkSeq;
		printWindow=window.open(url,"Print_Letter","height=200,width=400,resizable=1,scrollbars=1,location=0");
		printWindow.moveTo(0,0); // open in the top/left corner.
	}
}

// --- Goto Patient
function ctxGotoPatient() {
	hideCtxMenu();
	var bkStr=""+bkSeq;
	if (bkStr.indexOf('/')>0) { // Found this is an empty slot, because bkSeq=hh:mm/resource
		alert('There is no appointment in this timeslot');
	} else {
		var url='http://127.0.0.1:5195/ultra?OmnisServer=127.0.0.1:5195&OmnisLibrary=Mx&OmnisClass=rtPatient&bkSeq='+bkSeq;
		gotoWindow=window.open(url,"Goto_Patient","height=200,width=400,resizable=1,scrollbars=1,location=0");
		gotoWindow.moveTo(0,0); // open in the top/left corner.
	}
}

// --- Options to handle hiding/showing the menu.
var ioLastTarget="";
var ioLastColor="";

function highlightCell(psItem) {
	bkSeq=psItem; 						// Remember this item, used when selected below.
	if (ioLastTarget != "") { // There is a last target, reset the background colour
		ioLastTarget.backgroundColor=ioLastColor;
		ioLastTarget="";
	}
	// Highlight the cell that was selected.
	ioLastTarget = document.getElementById("bk"+bkSeq).style;	// Unique id eg "bk157" set by Omnis.  Want the style element.
	ioLastColor=ioLastTarget.backgroundColor; 	// Remember the last background colour so we can change it back later.
	ioLastTarget.backgroundColor="yellow";
	var voHideMenu = setTimeout('hideCtxMenu()',10000);		// deselects after 10 seconds automatically
	return false; // Need this for some reason.
}

function showCtxMenu(psItem,evt) {
	bkSeq=psItem; 						// Remember this item, used when selected below.
	
	var vnWindowWidth=window.innerWidth;	// Get the width/height of the current window.  Need to make sure we don't
	var vnWindowHeight=window.innerHeight;	// open off-screen.
	
	if (ioLastTarget != "") { // There is a last target, reset the background colour
		ioLastTarget.backgroundColor=ioLastColor;
		ioLastTarget="";
	}
	
	// Highlight the cell that was selected.
	ioLastTarget = evt.target.style;
	ioLastColor=ioLastTarget.backgroundColor; 	// Remember the last background colour so we can change it back later.
	ioLastTarget.backgroundColor="yellow";
	
	// Start with the default of where the mouse was clicked.
	var vnX=evt.clientX - 10 + document.body.scrollLeft; // Make the menu appear underneath the mouse
	var vnY=evt.clientY - 20 + document.body.scrollTop; // scrollTop/Left allows for scrolling of the window.
	
	var vnMenu = document.getElementById("Context");
	vnMenu.style.top = vnY;    				// top position is current mouse Y
	vnMenu.style.left = vnX; 				// left position is current mouse X
	vnMenu.style.display = 'block'; 		// Make the contextual menu visible
	var vnMenuWidth=vnMenu.clientWidth;		// Only get width/height after the menu is visible.
	var vnMenuHeight=vnMenu.clientHeight;
	vnMenu.style.top = Math.min(vnY,vnWindowHeight-vnMenuHeight-50);    // top position is current mouse Y
	vnMenu.style.left = Math.min(vnX,vnWindowWidth-vnMenuWidth-20); 	// left position is current mouse X
	
	var voHideMenu = setTimeout('hideCtxMenu()',10000);		// close after 10 seconds automatically
	
	return false; // Need this for some reason.
}

function hideCtxMenu() {
	var vnMenu = document.getElementById("Context");
	vnMenu.style.display = 'none'; // Make the contextual menu invisible
	if (ioLastTarget != "") { // There is a last target, reset the background colour
		ioLastTarget.backgroundColor=ioLastColor;
		ioLastTarget="";
	}
	return false;
}

// -----------------------------------
