/* -----------------------------------
This file is part of MxSolutions 5.7 and above
Copyright:      Logical Developments 2006 modified by Lokanet Pty Limited 2014-2015.
Project:        Mx Web Calendar System
Filename:       ajax.js
Author:         Paul W Mulroney
version:        0.05
Description: 	XML Handling routines 
History:
0.00    12-07-06 PWM   Created.
0.01	02-04-07 PWM   (ld0002811) Do not abort connection, causes problems at the other end.
0.02	09-07-07 PWM   Added call to recalculate schedule height after data loaded.
0.03	02-08-07 PWM   (ld0003119) Restore scroll position of schedule after update.
0.04	02-06-09 PWM   (mx0000555) Added option to redraw the cancellation (wait) list.
0.05	24-03-10 PWM   (mx0000275) removed wait list from sidebar.  now separate window.
0.06	27-05-10 PWM   (mx0000733) Added option to allow the user to highlight an appt from search.
----------------------------------- */

// The request object used for transmission 
function createRequestObject() { 
     var ro; 
     var browser = navigator.appName; 
     if(browser == "Microsoft Internet Explorer"){ 
         ro = new ActiveXObject("Microsoft.XMLHTTP"); 
     }else{ 
         ro = new XMLHttpRequest(); 
     } 
     return ro; 
} 
  
// Our normal request object.  Used to handle all requests
var http = createRequestObject(); 
var ibHttpBusy = false;	// Global associated with http
 
function sendRequest(action) { 
     if (ibHttpBusy==false) {	// If we're busy, we can't have two requests at once.
         try {
		 	http.open('get', 'rpc.php?op='+action); 
		 } catch(e) {
		 	alert('An error occurred trying to send the request.');
		 }
		 ibHttpBusy = true;	// We're busy now
		 http.onreadystatechange = handleResponse; 
		 http.send(null); 
     }
} 
  
function handleResponse() { 
    // Write response to the given DIV name.  Response is expected in the format <div name>|<div contents> 
    if(http.readyState == 4){ // 4= response is completed. 
         ibHttpBusy = false;  // no longer busy
     	 var response = http.responseText; 
         var update = new Array(); 
         hideWorkingMessage();
         if(response.indexOf('|' != -1)) { 
             update = response.split('|'); 
             document.getElementById(update[0]).innerHTML = update[1]; 
             // make the schedule update next.  Always.
             sendSchedRequest();
         } 
     } else if ((http.readyState<4)) { // progressing
     	showWorkingMessage();
     }
} 

// Schedule update.  Happens after one of the other areas is updated.
var sched = createRequestObject(); // MX Requires 2 objects: the nav/cal/res object and the sched object.
var ibSchedBusy = false;  // Global associated with sched

function sendSchedRequest() { 
     if (ibSchedBusy==false) {	// If we're busy, we can't have two requests at once.
		 try {
		 	sched.open('get', 'rpc.php?op=Sched&Date='+isDate);  // isDate is defined in the main page
		 } catch(e) {
		 	alert('An error occurred trying to send the schedule request.'+e);
		 }
		 ibSchedBusy = true;	// we're busy now.
		 sched.onreadystatechange = handleSchedResponse; 
		 sched.send(null); 
	}
} 
 
function handleSchedResponse() { 
    // Write response to the given DIV name.  Response is expected in the format <div name>|<div contents> 
    if(sched.readyState == 4){ //4= response is completed. 
         ibSchedBusy = false;	// we're not busy any more.
         hideWorkingMessage();
         var response = sched.responseText; 
         var update = new Array(); 
  
         if(response.indexOf('|' != -1)) { 
             update = response.split('|'); 
             var vnTop=document.getElementById("scrolling").scrollTop; // Remember the current position in the schedule before update
             document.getElementById(update[0]).innerHTML = update[1]; 
             resizeSchedule();	// Make sure that the schedule area is big enough.
             document.getElementById("scrolling").scrollTop=vnTop;		// Set the scroll position back to the top.
             if (isDate.indexOf(",")>=0) {
             	// Format is d/m/y,bkseq, 
             	var vlParams = isDate.split(",");
             	isDate = vlParams[0];		// First param is the date
             	var vnBkSeq = vlParams[1];	// second parameter is the booking sequence number. Used to ID the cell
             	highlightCell(vnBkSeq);
             }
          } 
     } else if ((sched.readyState<4)) { // progressing
     	showWorkingMessage();
     } 
} 
 
 
// Check screen redraw.  Polls the server for the last update
var csr = createRequestObject(); // Check screen redraw object.
var ibCsrBusy = false; // Global associated with CSR

function sendCSRRequest() { 
     if (ibCsrBusy==false) {	// If we're busy, we can't have two requests at once.
		 try {
		 	csr.open('get', 'rpc.php?op=Csr');   // Check screen redraw command, returns last update number
		 } catch(e) {
		 	alert('An error occurred trying to send the CSR request.'+e);
		 }
		 ibCsrBusy = true;	// we're busy now.
		 csr.onreadystatechange = handleCSRResponse; 
		 csr.send(null);
	}
} 

function stopCSRRequest() {
	// Stop the timeout for the CSR Request - only called if need to redraw now
	clearTimeout(csrTimer);
}

function checkTimeslot() {
	// Check the timeslot time - is it time to redraw anyway?  Return true if time for update
	// global isNextUpdate eg 16:50
	var now=new Date();
	var hrs=now.getHours();
	var min=now.getMinutes();
	var timeNow=(hrs<10?"0"+hrs:hrs)+":"+(min<10?"0"+min:min);
	if ((timeNow>isNextUpdate)&&(isNextUpdate!="")) {
		isNextUpdate="";	// Don't trigger again
		return true;
	} else {
		return false;
	}
}

function handleCSRResponse() { 
	// Check last redraw, and only reload schedule if this has changed
	if(csr.readyState == 4){ //4= response is completed. 
         ibCsrBusy = false;	// we're not busy any more.
		 var response = csr.responseText; 
		 var update = new Array(); 
	
		if (response!=isLastUpdate) { // isLastUpdate is defined in the main page	
			sendSchedRequest();		   // bookings have changed, force schedule reload
			isLastUpdate=response;     // Remember this update number
		 } else if (checkTimeslot()) { // Timeslot due for update
			sendSchedRequest();		   // bookings have changed, force schedule reload
			isLastUpdate=response;     // Remember this update number
	     }		 
		 csrTimer = setTimeout('sendCSRRequest()', 10000); // Send a csr request in 10 seconds time.
	 } 
} 

// Working Message Handling
function showWorkingMessage() {
	var wm=document.getElementById("WorkingMsg");
	if (wm!=null) {
     	wm.style.display = 'block'; // show the working message.	
	}
}

function hideWorkingMessage() {
	var wm=document.getElementById("WorkingMsg");
	if (wm!=null) {
		wm.style.display = 'none';	// hide the working message.
	}         
}

// Redraw functions
function redraw() {
	// Force a screen update
	stopCSRRequest();
	sendCSRRequest();
}

function redrawNow() {
	// Force a screen update from another window
	// This method is required because of a bug in firefox which prevents the http xml request from working from another window.
	var r=setTimeout("redraw()",1000); // queue it here.  It'll work just fine.
}

// ----------------------------------- 