<?php

/* -----------------------------------
This file is part of MxSolutions 5.7 and above
Copyright:      Logical Developments 2005 substantially modified by Lokanet Pty Limited 2014-2015.
Project:        Web based modular system
Filename:       index.php
Author:         Justin Allen
version:        0.08
Description: 	the heart of the web interface
History:
0.00    12-05-05 JRA   Created.
0.01	16-11-05 JRA   Added post vars handling
0.02	02-03-06 PWM   (ld0002209) Display logged in user using returned value from Login.  May contain extra info.
0.03	27-11-06 PWM   Moved css to separate folder
0.04	08-02-07 PWM   (ld0002818) Trap special chars in conversion string.
0.05	22-03-07 PWM   Extracted Omnis calls into separate file.
0.06	02-08-07 PWM   Added print specific style sheet.
0.07	11-08-10 PWM   Added favicon
0.08	29-02-12 PWM   (mx0001083) Suppress undefined index errors.
----------------------------------- */

include_once "config.php"; //load our config data
include_once "omnis.php";

session_start(); //start the session

//if we just came from the login page
if (!isset($_POST['Username'])) //If not isset -> set with dumy value 
{
	$_POST['Username'] = ""; 
}
if($_POST['Username'] != "") {
	//print_r($_POST);
	$_SESSION['Username'] = $_POST['Username'];
	$_SESSION['Password'] = $_POST['Password'];
}
//if the user is logging out erase the session variables
if (!isset($_GET['op'])) //If not isset -> set with dumy value 
{
	$_GET['op'] = ""; 
}
if($_GET['op'] == "Logout") {
	$_SESSION['Username'] = "";
	$_SESSION['Password'] = "";
}
$logindata = OmnisRequest("OmnisServer=$omnisserver:$omnisport&OmnisClass=rtLDBroker&OmnisLibrary=Bookings&CMD=GetLogin&Params=".$_SESSION['Username']."|".$_SESSION['Password']);
$query=''; // initialise the query string
if(($logindata == "_noone")|($logindata == "404")) { //omnis returns "_noone" if the login is incorrect
	$query = $_SERVER['QUERY_STRING'];
	if(strpos($query, "Login") === false) { // if we're not at the login page go there
		header( "Location: index.php?op=Login" );
		die; // additional output can cause problems so let's just stop output here
	}
}

if($_GET['op'] == "") { //if nothing show the welcome page
	$op = "INIT";
} else { //otherwise ask omnis to give us the page
	$op = $_GET['op'];
}
$outputtxt = OmnisRequest("OmnisServer=$omnisserver:$omnisport&OmnisClass=rtLDBroker&OmnisLibrary=Bookings&CMD=".$op."&Username=".$_SESSION['Username'].arr2and($_GET).arr2and($_POST));
if(substr($outputtxt,0,6) == "redir:") {
	header( "Location: ".substr($outputtxt,6) );
	die(); // additional output can cause problems so let's just stop output here
}
?>
<html>
<?php $logourl = "sscompanylogo.gif"; ?>
<head>
	<link rel="shortcut icon" type="image/x-icon" href="favicon.ico">
	<style type="text/css" media="screen">
	   @import "css/style.css";
	</style>
	<link rel="stylesheet" media="print" title="Printer-Friendly Calendar" type="text/css" href="css/print.css">
	<title>
		<?php
			$title = OmnisRequest("OmnisServer=$omnisserver:$omnisport&OmnisClass=rtLDBroker&OmnisLibrary=Bookings&CMD=CompanyName");
			if($title == "") { $title = "MxSolutions"; }
			echo $title;
		?>
	</title>
</head>
<body>
<?php if(strpos($query, "Login") === false) { //we can't display the menu if we aren't logged in
?>
<script language="JavaScript" vqptag="datafile" src="menu.php"></script>
<script language="JavaScript" vqptag="doc_level_settings" vqp_datafile0="menu.php" vqp_uid0=332630>
	//Document Level Menu Settings
	cdd__codebase = "javascript/"  	// all javascript in the javascript folder.
	cdd__codebase332630 = "" 		// This is the codebase for the commands that the menu executes.   
	cdd__activate_onclick = true
	cdd__showhide_delay = 200
	cdd__url_target = "_self"
	cdd__url_features = "resizable=1, scrollbars=1, titlebar=1, menubar=1, toolbar=1, location=1, status=1, directories=1, channelmode=0, fullscreen=0"
	cdd__display_urls_in_status_bar = true
	cdd__default_cursor = "default"
</script><script language="JavaScript"  vqptag="loader">
	if (window.showHelp){b_type = "ie"; if (!window.attachEvent) b_type += "mac";}if (document.createElementNS) b_type = "dom";if (navigator.userAgent.indexOf("afari")>-1) b_type = "safari";if (window.opera) b_type = "opera"; qmap1 = "\<\script language=\"JavaScript\" vqptag='loader_sub' src=\""; qmap2 = ".js\">\<\/script\>";;function iesf(){};;function vqp_error(val){alert(val)}
	if (b_type){document.write(qmap1+cdd__codebase+"pbrowser_"+b_type+qmap2);document.close();}
</script>
<?php } else { //just display a blank menubar
?>
<div id="menubar">
&nbsp;
</div>
<?php } ?>
<div id="maintitle"><h1>
		<?php
			$title = OmnisRequest("OmnisServer=$omnisserver:$omnisport&OmnisClass=rtLDBroker&OmnisLibrary=Bookings&CMD=CompanyName");
			if($title == "") { $title = "MxSolutions"; }
			echo $title;
		?>
</h1></div>
<div id="logged-in">Logged in as: 
<?php
	if($logindata == "_noone") {
		echo "Not logged in";
	} else {
		// echo $_SESSION['Username'];
		echo $logindata;	// PWM 21-02-06 (ld0002209)  Logindata contains extra info eg contact first name, surname.
	}
?>
</div>
<div id="container">
	<?php
		if(($outputtxt == "404")|($outputtxt == "")) { //Omnis returns 404 if the command isn't found
			echo "<p>Error: Command not implemented</p><p>This command is either not yet operational or you clicked on a bad link. If you feel that it was a bad link please let us know by emailing us at <a href=\"mailto:support@mxsolutions.com.au\">support@mxsolutions.com.au</a>.</p> <p><a href=\"index.php\">Return to the home page</a> to continue.</p>";
		} elseif(($outputtxt == "504 Gateway Time-out - could not connect to OMNIS server or load sharing process\n(Reported by OMNIS CGI program)")|($outputtxt == "503 Unable to locate specified Library or Class")) {
			echo "<p>Error: The database is currently offline, please try to connect later</p>";
		} else { //yay we got a page!
			echo $outputtxt;
		}
	?>
</div>
<?php if(strpos($query, "Login") === false) { // internet explorer forced us to put these at the bottom
 ?>
<div id="menubar">
<script language='JavaScript' vqptag='placement' vqp_menuid=332630>create_menu(332630)</script>
</div>
<?php } ?>
</body>
</html>
