<?php

/* -----------------------------------
This file is part of MxSolutions 5.7 and above
Copyright:      Logical Developments 2008 modified by Lokanet Pty Limited 2014-2015.
Project:        Web based modular system
Filename:       ical.php
Author:         Paul Mulroney
version:        0.00
Description: 	iCalendar request file
History:
0.00	08-02-08 PWM   Created.
----------------------------------- */

include_once "config.php"; //load our config data
include_once "omnis.php";

session_start(); //start the session

$op="ics"; // Operation is always an iCalendar request from this file.

$outputtxt = OmnisRequest("OmnisServer=$omnisserver:$omnisport&OmnisClass=rtLDBroker&OmnisLibrary=Bookings&CMD=".$op."&Username=".$_SESSION['Username'].arr2and($_GET).arr2and($_POST));
if(substr($outputtxt,0,6) == "redir:") {
	header( "Location: ".substr($outputtxt,6) );
	die(); // additional output can cause problems so let's just stop output here
}

$pos=strpos(strtolower($outputtxt),"content-type"); // do we have headers being returned?
if(($outputtxt == "404")|($outputtxt == "")) { 		//Omnis returns 404 if the command isn't found
	echo "404"; // 404 not found
} elseif(($outputtxt == "504 Gateway Time-out - could not connect to OMNIS server or load sharing process\n(Reported by OMNIS CGI program)")|($outputtxt == "503 Unable to locate specified Library or Class")) {
	echo "504";	// 504 gateway timeout.
} elseif($pos === false) { 							//yay we got a page!
	echo $outputtxt;
} else { 											// Got headers, need to extract the headers and the body
	$pos=strpos($outputtxt,sprintf("%c%c%c%c",13,10,13,10));	// The location of the break between the header and not
	$headers=explode(sprintf("%c%c",13,10),substr($outputtxt,0,$pos)); // Convert into an array of headers.
	$body=substr($outputtxt,$pos+4,strlen($outputtxt)); 		// The second part is the body

	foreach($headers as $thisheader) {
		header($thisheader);	// output each header in turn
	}
	echo $body;			// output the body
}
?>